*! version 5.0
* 13 August 2018
* NIDS
* Master Expenditure do file for Nids Wave 2

* THIS IS 5th EXPENDITURE DO FILE - POST-IMPUTATION AGGREGATION DO FILE: 5 OF 6
* THIS DO FILE AGGREGATES THE POST-IMPUTATION EXPENDITURE VARIABLES

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Expenditure do file (1 of 6)"

version 12.0

*=====================================================================================================================================

/*  NOTE: THIS DO FILE MUST BE RUN AFTER THE INCOME IMPUTATIONS HAVE BEEN RUN, AS
	IT PULLS IN THE IMPLIED INCOME FROM OWNER-OCCUPIED HOUSING VARIABLE THAT
	WAS CREATED IN THE INCOME IMPUTATION FILES.*/

use "$DataIN\hhderived_$VersionIN.dta", clear
*renpfix w2_
keep w2_hhid w2_hhimprent

merge 1:1 w2_hhid using "$DataOUT\imputed.dta"
drop _merge

egen expenditure=rowtotal(expf expnf rentexpend w2_hhimprent)
replace expenditure=. if expenditure==0
replace expenditure=. if phase2==1
replace expenditure=oneshotexp if expenditure==. & hhresponse==1

keep w2_hhid expf expnf rentexpend rentexpend_flg expenditure

save "$DataOUT\hhexp.dta", replace

* end of do file
*======================================================================================================================================
